'
'	Frank Lupo (Wolf) !!
'	Frank_lupo@email.it

'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Help
'
Option Explicit

Class ClsHelp
	Private HelpCommad

	Private Sub Class_Initialize
		Set HelpCommad = CreateObject("Scripting.Dictionary")

		HelpCommad.Add "ABORT", _
			Array("abort the current transaction", _
      			"ABORT [ WORK | TRANSACTION ]" ) 

		HelpCommad.Add "ALTER GROUP", _
			Array("add users to a group or remove users from a group", _
    		  	"ALTER GROUP name ADD USER username [, ... ]" & vbcrlf & _
				"ALTER GROUP name DROP USER username [, ... ]")

		HelpCommad.Add "ALTER TABLE", _
			Array("change the definition of a table", _
    		  	"ALTER TABLE [ ONLY ] table [ * ]" & vbcrlf & _
				"    ADD [ COLUMN ] column type [ column_constraint [ ... ] ]" & vbcrlf & _
				"ALTER TABLE [ ONLY ] table [ * ]" & vbcrlf & _
				"    ALTER [ COLUMN ] column { SET DEFAULT value | DROP DEFAULT }" & vbcrlf & _
				"ALTER TABLE [ ONLY ] table [ * ]" & vbcrlf & _
				"    ALTER [ COLUMN ] column SET STATISTICS integer" & vbcrlf & _
				"ALTER TABLE [ ONLY ] table [ * ]" & vbcrlf & _
				"    RENAME [ COLUMN ] column TO newcolumn" & vbcrlf & _
				"ALTER TABLE table" & vbcrlf & _
				"    RENAME TO newtable" & vbcrlf & _
				"ALTER TABLE table" & vbcrlf & _
				"    ADD table constraint definition" & vbcrlf & _
				"ALTER TABLE [ ONLY ] table " & vbcrlf & _
				"	DROP CONSTRAINT constraint { RESTRICT | CASCADE }" & vbcrlf & _
				"ALTER TABLE table" & vbcrlf & _
				"	OWNER TO new owner" )
	
		HelpCommad.Add "ALTER USER", _
			Array("change a database user account", _
				"ALTER USER username [ [ WITH ] option [ ... ] ]" & vbcrlf & vbcrlf & _
				"where option can be:" & vbcrlf & vbcrlf & _
				"	  [ ENCRYPTED | UNENCRYPTED ] PASSWORD 'password' " & vbcrlf & _
				"        | CREATEDB | NOCREATEDB" & vbcrlf & _
				"        | CREATEUSER | NOCREATEUSER " & vbcrlf & _
				"        | VALID UNTIL 'abstime'")

		HelpCommad.Add "ANALYZE", _
			Array("collect statistics about a database", _
				"ANALYZE [ VERBOSE ] [ table [ (column [, ...] ) ] ]" )

		HelpCommad.Add "BEGIN", _
			Array("start a transaction block", _
    		  	"BEGIN [ WORK | TRANSACTION ]" )

		HelpCommad.Add "CHECKPOINT", _
			Array("force a transaction log checkpoint", _
    	  		"CHECKPOINT")

		HelpCommad.Add "CLOSE", _
			Array("close a cursor", _
		 		"CLOSE cursor")

		HelpCommad.Add "CLUSTER", _
			Array("cluster a table according to an index", _
      			"CLUSTER indexname ON tablename")

		HelpCommad.Add "COMMENT", _
			Array("define or change the comment of an object", _
				"COMMENT ON" & vbcrlf & _
				"[" & vbcrlf & _
				"  [ DATABASE | INDEX | RULE | SEQUENCE | TABLE | TYPE | VIEW ] object_name |" & vbcrlf & _
				"  COLUMN table_name.column_name |" & vbcrlf & _
				"  AGGREGATE agg_name (agg_type) |" & vbcrlf & _
				"  FUNCTION func_name (arg1, arg2, ...) |" & vbcrlf & _
				"  OPERATOR op (leftoperand_type rightoperand_type) |" & vbcrlf & _
				"  TRIGGER trigger_name ON table_name" & vbcrlf & _
				"] IS 'text'")

		HelpCommad.Add "COMMIT", _
			Array("commit the current transaction", _
				"COMMIT [ WORK | TRANSACTION ]")

		HelpCommad.Add "COPY", _
			Array("copy data between files and tables", _
				"COPY [ BINARY ] table [ WITH OIDS ]" & vbcrlf & _
				"    FROM { 'filename' | stdin }" & vbcrlf & _
				"    [ [USING] DELIMITERS 'delimiter' ]" & vbcrlf & _
				"    [ WITH NULL AS 'null string' ]" & vbcrlf & _
				"COPY [ BINARY ] table [ WITH OIDS ]" & vbcrlf & _
				"    TO { 'filename' | stdout }" & vbcrlf & _
				"    [ [USING] DELIMITERS 'delimiter' ]" & vbcrlf & _
				"    [ WITH NULL AS 'null string' ]")

		HelpCommad.Add "CREATE AGGREGATE", _
			Array("define a new aggregate function", _
				"CREATE AGGREGATE name ( BASETYPE = input_data_type," & vbcrlf & _
				"    SFUNC = sfunc, STYPE = state_type" & vbcrlf & _
				"    [ , FINALFUNC = ffunc ]" & vbcrlf & _
				"    [ , INITCOND = initial_condition ] )")

		HelpCommad.Add "CREATE CONSTRAINT TRIGGER", _
			Array("define a new constraint trigger", _
				"CREATE CONSTRAINT TRIGGER name" & vbcrlf & _
				"    AFTER events ON" & vbcrlf & _
				"    relation constraint attributes" & vbcrlf & _
				"    FOR EACH ROW EXECUTE PROCEDURE func '(' args ')'")

		HelpCommad.Add "CREATE DATABASE", _
			Array("create a new database", _
				"CREATE DATABASE name" & vbcrlf & _
				"    [ WITH [ LOCATION = 'dbpath' ]" & vbcrlf & _
				"           [ TEMPLATE = template ]" & vbcrlf & _
				"           [ ENCODING = encoding ] ]")

		HelpCommad.Add "CREATE FUNCTION", _
			Array("define a new function", _
				"CREATE [ OR REPLACE ] FUNCTION name ( [ argtype [, ...] ] ) " & vbcrlf & _
				"    RETURNS rettype" & vbcrlf & _
				"    AS 'definition'" & vbcrlf & _
				"    LANGUAGE langname" & vbcrlf & _
				"    [ WITH ( attribute [, ...] ) ]" & vbcrlf & _
				"CREATE [ OR REPLACE ] FUNCTION name ( [ argtype [, ...] ] )" & vbcrlf & _
				"    RETURNS rettype" & vbcrlf & _
				"    AS 'obj_file', 'link_symbol'" & vbcrlf & _
				"    LANGUAGE langname" & vbcrlf & _
				"    [ WITH ( attribute [, ...] ) ]")

		HelpCommad.Add "CREATE GROUP", _
			Array("define a new user group", _
				"CREATE GROUP name [ [ WITH ] option [ ... ] ]" & vbcrlf & vbcrlf & _
				"where option can be:" & vbcrlf & vbcrlf & _
				"     SYSID gid" & vbcrlf & _
				"   | USER  username [, ...]")

		HelpCommad.Add "CREATE INDEX", _
			Array("define a new index", _
				"CREATE [ UNIQUE ] INDEX index_name ON table" & vbcrlf & _
				"    [ USING acc_method ] ( column [ ops_name ] [, ...] )" & vbcrlf & _
				"    [ WHERE predicate ]" & vbcrlf & _
				"CREATE [ UNIQUE ] INDEX index_name ON table" & vbcrlf & _
				"    [ USING acc_method ] ( func_name( column [, ... ]) [ ops_name ] )" & vbcrlf & _
				"    [ WHERE predicate ]")

		HelpCommad.Add "CREATE LANGUAGE", _
			Array("define a new procedural language", _
				"CREATE [ TRUSTED ] [ PROCEDURAL ] LANGUAGE langname" & vbcrlf & _
				"    HANDLER call_handler")

		HelpCommad.Add "CREATE OPERATOR", _
			Array("define a new operator", _
				"CREATE OPERATOR name ( PROCEDURE = func_name" & vbcrlf & _
				"     [, LEFTARG = lefttype" & vbcrlf & _
				"     ] [, RIGHTARG = righttype ]" & vbcrlf & _
				"     [, COMMUTATOR = com_op ] [, NEGATOR = neg_op ]" & vbcrlf & _
				"     [, RESTRICT = res_proc ] [, JOIN = join_proc ]" & vbcrlf & _
				"     [, HASHES ] [, SORT1 = left_sort_op ] [, SORT2 = right_sort_op ] )")

		HelpCommad.Add "CREATE RULE", _
			Array("define a new rewrite rule", _
				"CREATE RULE name AS ON event" & vbcrlf & _
				"    TO object [ WHERE condition ]" & vbcrlf & _
				"    DO [ INSTEAD ] action" & vbcrlf & vbcrlf & _
				"where action can be:" & vbcrlf & vbcrlf & _
				"NOTHING" & vbcrlf & _
				"|" & vbcrlf & _
				"query" & vbcrlf & vbcrlf & _
				"( query ; query ... )" & vbcrlf & _
				"|" & vbcrlf & _
				"[ query ; query ... ]")

		HelpCommad.Add "CREATE SEQUENCE", _
			Array("define a new sequence generator", _
				"CREATE [ TEMPORARY | TEMP ] SEQUENCE seqname [ INCREMENT increment ]" & vbcrlf & _
				"    [ MINVALUE minvalue ] [ MAXVALUE maxvalue ]" & vbcrlf & _
				"    [ START start ] [ CACHE cache ] [ CYCLE ]")

		HelpCommad.Add "CREATE TABLE", _
			Array("define a new table", _
				"CREATE [ [ LOCAL ] { TEMPORARY | TEMP } ] TABLE table_name (" & vbcrlf & _
				"    { column_name data_type [ DEFAULT default_expr ] [ column_constraint [, ... ] ]"  & vbcrlf & _
				"    | table_constraint }  [, ... ]"  & vbcrlf & _
				")"  & vbcrlf & _
				"[ INHERITS ( parent_table [, ... ] ) ]"  & vbcrlf & _
				"[ WITH OIDS | WITHOUT OIDS ]" & vbcrlf & vbcrlf & _
				"where column_constraint is:"& vbcrlf & vbcrlf & _
				"[ CONSTRAINT constraint_name ]" & vbcrlf & _
				"{ NOT NULL | NULL | UNIQUE | PRIMARY KEY |" & vbcrlf & _
				"  CHECK (expression) |" & vbcrlf & _
				"  REFERENCES reftable [ ( refcolumn ) ] [ MATCH FULL | MATCH PARTIAL ]" & vbcrlf & _
				"    [ ON DELETE action ] [ ON UPDATE action ] }" & vbcrlf & _
				"[ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]" & vbcrlf & vbcrlf & _
				"and table_constraint is:" & vbcrlf & vbcrlf & _
				"[ CONSTRAINT constraint_name ]" & vbcrlf & _
				"{ UNIQUE ( column_name [, ... ] ) |" & vbcrlf & _
				"  PRIMARY KEY ( column_name [, ... ] ) |" & vbcrlf & _
				"  CHECK ( expression ) |" & vbcrlf & _
				"  FOREIGN KEY ( column_name [, ... ] ) REFERENCES reftable [ ( refcolumn [, ... ] ) ]" & vbcrlf & _
				"    [ MATCH FULL | MATCH PARTIAL ] [ ON DELETE action ] [ ON UPDATE action ] }" & vbcrlf & _
				"[ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]")

		HelpCommad.Add "CREATE TABLE AS", _
			Array("create a new table from the results of a query", _
				"CREATE [ [ LOCAL ] { TEMPORARY | TEMP } ] TABLE table_name [ (column_name [, ...] ) ]" & vbcrlf & _
    			"AS query")

		HelpCommad.Add "CREATE TRIGGER", _
			Array("define a new trigger", _
				"CREATE TRIGGER name { BEFORE | AFTER } { event [OR ...] }" & vbcrlf & _
				"    ON table FOR EACH { ROW | STATEMENT }" & vbcrlf & _
				"    EXECUTE PROCEDURE func ( arguments )")

		HelpCommad.Add "CREATE TYPE", _
			Array("define a new data type", _
				"CREATE TYPE typename ( INPUT = input_function, OUTPUT = output_function" & vbcrlf & _
				"      , INTERNALLENGTH = { internallength | VARIABLE }" & vbcrlf & _
				"    [ , EXTERNALLENGTH = { externallength | VARIABLE } ]" & vbcrlf & _
				"    [ , DEFAULT = default ]" & vbcrlf & _
				"    [ , ELEMENT = element ] [ , DELIMITER = delimiter ]" & vbcrlf & _
				"    [ , SEND = send_function ] [ , RECEIVE = receive_function ]" & vbcrlf & _
				"    [ , PASSEDBYVALUE ]" & vbcrlf & _
				"    [ , ALIGNMENT = alignment ]" & vbcrlf & _
				"    [ , STORAGE = storage ]" & vbcrlf & _
				")")

		HelpCommad.Add "CREATE USER", _
			Array("define a new database user account", _
				"CREATE USER username [ [ WITH ] option [ ... ] ]" & vbcrlf & vbcrlf & _
				"where option can be:" & vbcrlf & vbcrlf & _
				"	  SYSID uid " & vbcrlf & _
				"        | [ ENCRYPTED | UNENCRYPTED ] PASSWORD 'password'" & vbcrlf & _
				"        | CREATEDB | NOCREATEDB\n        | CREATEUSER | NOCREATEUSER" & vbcrlf & _
				"        | IN GROUP groupname [, ...]" & vbcrlf & _
				"        | VALID UNTIL 'abstime'")

		HelpCommad.Add "CREATE VIEW", _
			Array("define a new view", _
				"CREATE VIEW view [ ( column name list ) ] AS SELECT query")

		HelpCommad.Add "DECLARE", _
			Array("define a cursor", _
				"DECLARE cursorname [ BINARY ] [ INSENSITIVE ] [ SCROLL ]" & vbcrlf & _
				"    CURSOR FOR query" & vbcrlf & _
				"    [ FOR { READ ONLY | UPDATE [ OF column [, ...] ] ]")

		HelpCommad.Add "DELETE", _
			Array("delete rows of a table", _
				"DELETE FROM [ ONLY ] table [ WHERE condition ]")

		HelpCommad.Add "DROP AGGREGATE", _
			Array("remove a user-defined aggregate function", _
				"DROP AGGREGATE name ( type )")

		HelpCommad.Add "DROP DATABASE", _
			Array("remove a database", _
      			"DROP DATABASE name") 

		HelpCommad.Add "DROP FUNCTION", _
			Array("remove a user-defined function", _
      			"DROP FUNCTION name ( [ type [, ...] ] )")

		HelpCommad.Add "DROP GROUP", _
			Array("remove a user group", _
      			"DROP GROUP name")

		HelpCommad.Add "DROP INDEX", _
			Array("remove an index", _
				"DROP INDEX index_name [, ...]")

		HelpCommad.Add "DROP LANGUAGE", _
			Array("remove a user-defined procedural language", _
      			"DROP [ PROCEDURAL ] LANGUAGE name")

		HelpCommad.Add "DROP OPERATOR", _
			Array("remove a user-defined operator", _
				"DROP OPERATOR id ( lefttype | NONE , righttype | NONE )")

		HelpCommad.Add "DROP RULE", _
			Array("remove a rewrite rule", _
      			"DROP RULE name [, ...]")

		HelpCommad.Add "DROP SEQUENCE", _
			Array("remove a sequence", _
      			"DROP SEQUENCE name [, ...]")

		HelpCommad.Add "DROP TABLE", _
			Array("remove a table", _
      			"DROP TABLE name [, ...]")

		HelpCommad.Add "DROP TRIGGER", _
			Array("remove a trigger", _
				"DROP TRIGGER name ON table")

		HelpCommad.Add "DROP TYPE", _
			Array("remove a user-defined data type", _
				"DROP TYPE typename [, ...]")

		HelpCommad.Add "DROP USER", _
			Array("remove a database user account", _
				"DROP USER name")

		HelpCommad.Add "DROP VIEW", _
			Array("remove a view", _
				"DROP VIEW name [, ...]")

		HelpCommad.Add "END", _
			Array("commit the current transaction", _
				"END [ WORK | TRANSACTION ]")

		HelpCommad.Add "EXPLAIN", _
			Array("show the execution plan of a statement", _
				"EXPLAIN [ ANALYZE ] [ VERBOSE ] query")

		HelpCommad.Add "FETCH", _
			Array("retrieve rows from a table using a cursor", _
				"FETCH [ direction ] [ count ] { IN | FROM } cursor" & vbcrlf & _
				"FETCH [ FORWARD | BACKWARD | RELATIVE ] [ # | ALL | NEXT | PRIOR ] { IN | FROM } cursor")

		HelpCommad.Add "GRANT", _
			Array("define access privileges", _
				"GRANT { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER } [,...] | ALL [ PRIVILEGES ] }" & vbcrlf & _
				"    ON [ TABLE ] objectname [, ...]" & vbcrlf & _
				"    TO { username | GROUP groupname | PUBLIC } [, ...]")

		HelpCommad.Add "INSERT", _
			Array("create new rows in a table", _
				"INSERT INTO table [ ( column [, ...] ) ]" & vbcrlf & _
				"    { DEFAULT VALUES | VALUES ( expression [, ...] ) | SELECT query }")

		HelpCommad.Add "LISTEN", _
			Array("listen for a notification", _
				"LISTEN name")

		HelpCommad.Add "LOAD", _
			Array("load or reload a shared library file", _
				"LOAD 'filename'")

		HelpCommad.Add "LOCK", _
			Array("explicitly lock a table", _
				"LOCK [ TABLE ] name [, ...]" & vbcrlf & _
				"LOCK [ TABLE ] name [, ...] IN lockmode MODE" & vbcrlf & vbcrlf & _
				"where lockmode is one of:"& vbcrlf & vbcrlf & _
				"	ACCESS SHARE | ROW SHARE | ROW EXCLUSIVE | SHARE UPDATE EXCLUSIVE |"& vbcrlf & _
				"	SHARE | SHARE ROW EXCLUSIVE | EXCLUSIVE | ACCESS EXCLUSIVE")

		HelpCommad.Add "MOVE", _
			Array("position a cursor on a specified row of a table", _
				"MOVE [ direction ] [ count ]" & vbcrlf & _
				"    { IN | FROM } cursor")

		HelpCommad.Add "NOTIFY", _
			Array("generate a notification", _
				"NOTIFY name")

		HelpCommad.Add "REINDEX", _
			Array("rebuild corrupted indexes", _
				"REINDEX { TABLE | DATABASE | INDEX } name [ FORCE ]")

		HelpCommad.Add "RESET", _
			Array("restore the value of a run-time parameter to a default value", _
				"RESET variable")

		HelpCommad.Add "REVOKE", _
			Array("remove access privileges", _
				"REVOKE { { SELECT | INSERT | UPDATE | DELETE | RULE | REFERENCES | TRIGGER } [,...] | ALL [ PRIVILEGES ] }" & vbcrlf & _
				"    ON [ TABLE ] object [, ...]" & vbcrlf & _
				"    FROM { username | GROUP groupname | PUBLIC } [, ...]")

		HelpCommad.Add "ROLLBACK", _
			Array("abort the current transaction", _
				"ROLLBACK [ WORK | TRANSACTION ]")

		HelpCommad.Add "SELECT", _
			Array("retrieve rows from a table or view", _
				"SELECT [ ALL | DISTINCT [ ON ( expression [, ...] ) ] ]" & vbcrlf & _
				"    * | expression [ AS output_name ] [, ...]" & vbcrlf & _
				"    [ FROM from_item [, ...] ]" & vbcrlf & _
				"    [ WHERE condition ]" & vbcrlf & _
				"    [ GROUP BY expression [, ...] ]" & vbcrlf & _
				"    [ HAVING condition [, ...] ]" & vbcrlf & _
				"    [ { UNION | INTERSECT | EXCEPT } [ ALL ] select ]" & vbcrlf & _
				"    [ ORDER BY expression [ ASC | DESC | USING operator ] [, ...] ]" & vbcrlf & _
				"    [ FOR UPDATE [ OF tablename [, ...] ] ]" & vbcrlf & _
				"    [ LIMIT { count | ALL } ]" & vbcrlf & _
				"    [ OFFSET start ]" & vbcrlf & vbcrlf & _
				"where from_item can be:" & vbcrlf & vbcrlf & _
				"[ ONLY ] table_name [ * ]" & vbcrlf & _
				"    [ [ AS ] alias [ ( column_alias_list ) ] ]" & vbcrlf & _
				"|" & vbcrlf & _
				"( select )" & vbcrlf & _
				"    [ AS ] alias [ ( column_alias_list ) ]" & vbcrlf & _
				"|" & vbcrlf & _
				"from_item [ NATURAL ] join_type from_item" & vbcrlf & _
				"    [ ON join_condition | USING ( join_column_list ) ]")

		HelpCommad.Add "SELECT INTO", _
			Array("create a new table from the results of a query", _
				"SELECT [ ALL | DISTINCT [ ON ( expression [, ...] ) ] ]" & vbcrlf & _
				"    * | expression [ AS output_name ] [, ...]" & vbcrlf & _
				"    INTO [ TEMPORARY | TEMP ] [ TABLE ] new_table" & vbcrlf & _
				"    [ FROM from_item [, ...] ]" & vbcrlf & _
				"    [ WHERE condition ]" & vbcrlf & _
				"    [ GROUP BY expression [, ...] ]" & vbcrlf & _
				"    [ HAVING condition [, ...] ]" & vbcrlf & _
				"    [ { UNION | INTERSECT | EXCEPT } [ ALL ] select ]" & vbcrlf & _
				"    [ ORDER BY expression [ ASC | DESC | USING operator ] [, ...] ]" & vbcrlf & _
				"    [ FOR UPDATE [ OF tablename [, ...] ] ]" & vbcrlf & _
				"    [ LIMIT [ start , ] { count | ALL } ]" & vbcrlf & _
				"    [ OFFSET start ]\n\nwhere from_item can be:" & vbcrlf & vbcrlf & _
				"[ ONLY ] table_name [ * ]" & vbcrlf & _
				"    [ [ AS ] alias [ ( column_alias_list ) ] ]" & vbcrlf & _
				"|" & vbcrlf & _
				"( select )" & vbcrlf & _
				"    [ AS ] alias [ ( column_alias_list ) ]" & vbcrlf & _
				"|" & vbcrlf & _
				"from_item [ NATURAL ] join_type from_item" & vbcrlf & _
				"    [ ON join_condition | USING ( join_column_list ) ]")

		HelpCommad.Add "SET", _
			Array("change a run-time parameter", _
				"SET variable { TO | = } { value | 'value' | DEFAULT }" & vbcrlf & _
				"SET TIME ZONE { 'timezone' | LOCAL | DEFAULT }")

		HelpCommad.Add "SET CONSTRAINTS", _
			Array("set the constraint mode of the current transaction", _
				"SET CONSTRAINTS { ALL | constraint [, ...] } { DEFERRED | IMMEDIATE }")

		HelpCommad.Add "SET SESSION AUTHORIZATION", _
			Array("set the session user identifier and the current user identifier of the current session", _
      			"SET SESSION AUTHORIZATION 'username'")

		HelpCommad.Add "SET TRANSACTION", _
			Array("set the characteristics of the current transaction", _
				"SET TRANSACTION ISOLATION LEVEL { READ COMMITTED | SERIALIZABLE }" & vbcrlf & _
				"SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL" & vbcrlf & _
				"    { READ COMMITTED | SERIALIZABLE }")

		HelpCommad.Add "SHOW", _
			Array("show the value of a run-time parameter", _
				"SHOW name")

		HelpCommad.Add "TRUNCATE", _
			Array("empty a table", _
				"TRUNCATE [ TABLE ] name")

		HelpCommad.Add "UNLISTEN", _
			Array("stop listening for a notification", _
				"UNLISTEN { notifyname | * }")

		HelpCommad.Add "UPDATE", _
			Array("update rows of a table", _
				"UPDATE [ ONLY ] table SET col = expression [, ...]" & vbcrlf & _
				"    [ FROM fromlist ]" & vbcrlf & _
				"    [ WHERE condition ]")

		HelpCommad.Add "VACUUM", _
			Array("garbage-collect and optionally analyze a database", _
				"VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] [ table ]" & vbcrlf & _
				"VACUUM [ FULL ] [ FREEZE ] [ VERBOSE ] ANALYZE [ table [ (column [, ...] ) ] ]")
	End Sub

	Private Sub Class_Terminate
	End Sub

	Public Sub ShowHelp(szNameCommand)
	Dim szCommand

		if len(trim(szNameCommand)) = 0 then
			for each szCommand in HelpCommad
				PrintHelp szCommand
			next 
		else
			PrintHelp szNameCommand
		end if
	End Sub

	Private Sub PrintHelp(szNameCommand)
	dim szCommand,vData

		szCommand=Ucase(Trim(szNameCommand))
		if HelpCommad.Exists(szCommand) then
			vData=HelpCommad(szCommand)
			wscript.echo "Command:     " & szCommand
			wscript.echo "Description: " & vData(0)
			wscript.echo "Syntax:" & vbcrlf & vData(1) & vbcrlf
		else
			wscript.echo "No help available for " & szCommand & "."
			wscript.echo "Try \h with no arguments to see available help."
		end if
	End Sub
End Class
